/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.advancements;

import betteradvancements.advancements.BetterDisplayInfo;
import betteradvancements.platform.Services;
import betteradvancements.reference.Constants;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_161;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class BetterDisplayInfoRegistry {
    private final Map<class_2960, BetterDisplayInfo> registry = new HashMap<class_2960, BetterDisplayInfo>();

    public BetterDisplayInfoRegistry(class_161 advancement) {
    }

    public BetterDisplayInfo get(class_161 advancement) {
        return this.registry.getOrDefault(advancement.method_688(), new BetterDisplayInfo(advancement));
    }

    private void load(class_2960 location, class_3218 serverLevel) {
        Services.PLATFORM.getAdvancementVisitor().findAdvancements(location, serverLevel, null, (root, file) -> {
            String relative;
            try {
                relative = root.relativize((Path)file).toString();
            }
            catch (Exception e) {
                relative = "";
            }
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            class_2960 key = new class_2960(location.method_12836(), name);
            if (!this.registry.containsKey(key)) {
                BufferedReader reader = null;
                try {
                    reader = Files.newBufferedReader(file);
                    JsonObject advancement = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    JsonObject betterDisplay = advancement.getAsJsonObject("better_display");
                    this.registry.put(key, new BetterDisplayInfo(key, betterDisplay));
                }
                catch (JsonParseException jsonparseexception) {
                    Constants.log.error("Parsing error loading built-in advancement " + key, (Throwable)jsonparseexception);
                    Boolean bl = false;
                    return bl;
                }
                catch (IOException ioexception) {
                    Constants.log.error("Couldn't read advancement " + key + " from " + file, (Throwable)ioexception);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            return true;
        }, true, true);
    }
}

